# --------------------------
# --------------------------
# Model simulations
# --------------------------
# --------------------------

rootDirectory = '' # YOU must set this!

rdaInputDirectory = paste(rootDirectory,'/Scripts & model output Fivash et al 2021 JAppEcol/Figures 2 & S1 - Pareto optimum figure/RDA', sep = '')
functionDirectory = paste(rootDirectory,'/Scripts & model output Fivash et al 2021 JAppEcol/Functions', sep = '')
source(paste(functionDirectory,'callFunctions.R', sep = ''))
callFunctions(functionDirectory)

calculateTimeToSuccess = function(x){
  timeToSuccess = NA
  if(sum(x == 1) > 0){
    timeToSuccess = min(which(x == 1)) 
  }
  return(timeToSuccess)
}
calculateAvgTimeToSuccess = function(X){
  return(exp(mean(log(unlist(apply(X = X, MARGIN = 2, FUN = calculateTimeToSuccess))), na.rm = T)))
}

library(raster)
# --------------------------

setwd(rdaDirectory)
load('Figure2_grids.rda')

# Monte Carlo Analysis of Grids (takes long): ------- #

n_matrices = dim(MiSeries)[3]
n_runs = 100
tf = 20000
set.seed(1234)
disturbanceSeq = exp(runif(n = n_runs, min = log(0.25),max = log(2.5)))

failure.perc = avgTimeToSuccess = rep(NA, times = n_matrices)
for(i_Mi in 1:n_matrices){
  
  # Run simulations
  output = monteCarloTrials(Mi = MiSeries[,,i_Mi], 
                                         n_runs = n_runs,
                                         tf = tf,
                                         disturbanceSeq = disturbanceSeq)
  
  # Make a plot
  par(mfrow = c(2,1))
  par(mar = c(4,5,4,2))
  time = 1:tf
  col = colorRampPalette(c('blue','red'))(1000)
  disturbColSeq = exp(seq(log(0.25),log(2.5), length.out = 1000))
  for(i_run in 1:n_runs){
    colIndex = which.min(abs(disturbanceSeq[i_run] - disturbColSeq))
    if(i_run == 1){
      plot(100*output[,i_run] ~ time, type = 'l',
           ylab = 'Vegetation cover (%)', xlab = 'Time',
           log = 'x',
           main = paste(i_Mi,'/',n_matrices),
           ylim = c(0,100), xlim = c(1,tf),
           col = col[colIndex])
    } else {
      lines(100*output[,i_run] ~ time, col = col[colIndex])
    }
  }
  lines(100*rowMeans(output) ~ time, lwd = 3)
  par(mar = c(1,4,1,0))
  plot(raster(MiSeries[,,i_Mi]),
       box = F, axes = F, legend = F)
  par(mfrow = c(1,1))

  # Calculate output parameters: (1) speed of colonization and (2) chance of failure
  avgTimeToSuccess[i_Mi] = calculateAvgTimeToSuccess(output)
  failure.perc[i_Mi] = mean(output[dim(output)[1],] == 0)*100
  
  print(paste(i_Mi,'/',n_matrices))
}

# Calculate VMR value of each pattern
VMR = apply(MiSeries, MARGIN = 3, FUN = clumpinessIndex, windowSize = 10)

frame.ID = 1:428
data = data.frame(frame.ID, VMR, failure.perc, avgTimeToSuccess)
setwd(rdaDirectory)
save(data, file = 'Figure2_trials.rda')
